//Tabs unter Symbolleiste

(function() {
  var tabbar = document.getElementById('TabsToolbar');
  if (tabbar && !tabbar.collapsed) {
    tabbar.parentNode.parentNode.appendChild(tabbar);
  };
  
  var css =` @-moz-document url-prefix("chrome://browser/content/browser.xhtml") {

   

    /* Anpassung der Symbolleiste */
    [tabsintitlebar="true"] #toolbar-menubar { height: 29px; }
    [tabsintitlebar="true"][sizemode="maximized"] #navigator-toolbox { padding-top: 8px !important; }
    #titlebar,#tabbrowser-tabs { -moz-appearance: none !important; }

    /* Windows 10 und Firefox Standardtheme, Fensteraussenlinie in weiß. 
       Anpassung für Titelleistenschaltflächen wenn sie in den Hintergrund verschoben sind */
    #main-window:not([lwtheme="true"]) #TabsToolbar .titlebar-buttonbox .titlebar-button,
    #main-window:not([lwtheme="true"]) #window-controls toolbarbutton { color: rgb(24, 25, 26) !important; }
    #main-window:not([lwtheme="true"]) #TabsToolbar .titlebar-buttonbox .titlebar-button:not(.titlebar-close):hover,
    #main-window:not([lwtheme="true"]) #window-controls toolbarbutton:not([id="close-button"]):hover {
        background-color: var(--lwt-toolbarbutton-hover-background, hsla(0,0%,70%,.4)) !important; }

    /* Anpassung für Titelleistenschaltflächen */
    [tabsintitlebar="true"] .titlebar-buttonbox-container { display: block; position: fixed; right:0; }
    [tabsintitlebar="true"][sizemode="normal"] .titlebar-buttonbox-container { top: 1px; }
    [tabsintitlebar="true"][sizemode="maximized"] .titlebar-buttonbox-container { top: 8px; }

    /* auf der rechten Seite Platz für die Schaltflächen der Titelleiste einfügen, damit die    
       Schaltflächen der Titelleiste und der Navigationsleiste nicht verdeckt werden */
    [tabsintitlebar="true"] #toolbar-menubar[autohide="true"][inactive="true"] ~ #nav-bar:not([inFullscreen="true"]) { padding-right: 9px !important; }
    #navigator-toolbox[inFullscreen="true"] #nav-bar { padding-right: 109px !important; }

    /* Platz für Scrollbar schaffen */
    .tabbrowser-tabs {
        margin-right: -41px !important; }

    box[class="scrollbox-clip"][orient="horizontal"],
    tabs > arrowscrollbox { 
        display: block; }

    scrollbox[part][orient="horizontal"] {
        display: flex;
        flex-wrap: wrap; 
        overflow: visible !important;
        overflow-x: hidden !important;
        overflow-y: auto !important;
        min-height: 27px !important; /* Tab-Höhe(27px) + 2px */
        max-height: calc( 3 * 29px ) !important;  /* Anzahl der Tabreihen * Minimal-Höhe */
        -moz-window-dragging: no-drag !important; }

    /* Buttons/Zwischenräume Ausblenden */
    hbox.titlebar-spacer,
    [class="scrollbutton-up"],
    [class="scrollbutton-up"] + spacer,
    scrollbox[part][orient="horizontal"] + spacer,
    [class="scrollbutton-down"] { 
        display: none; }

    #TabsToolbar > .titlebar-buttonbox-container {
        display: none !important; }    

    /* Drag-Bereich auf der linken und rechten Seite der
       Tab-Leiste ausblenden - verstecken
       Links und rechts → hbox.titlebar-spacer 
       links → hbox.titlebar-spacer[type="pre-tabs"] 
       rechts → hbox.titlebar-spacer[type="post-tabs"] */
    hbox.titlebar-spacer
    ,
    /* Ausblenden - Verstecken */
    #alltabs-button,
    tabs tab:not([fadein]),
    #toolbar-menubar[autohide="false"] + #titlebar #TabsToolbar .titlebar-buttonbox-container,
    [class="scrollbutton-up"],
    [class="scrollbutton-up"] ~ spacer,
    [class="scrollbutton-down"] { display: none; }
    
    } `;
    
    var sss = Cc['@mozilla.org/content/style-sheet-service;1'].getService(Ci.nsIStyleSheetService);
    var uri = makeURI('data:text/css;charset=UTF=8,' + encodeURIComponent(css));
    sss.loadAndRegisterSheet(uri, sss.AGENT_SHEET);

})();